/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.block_set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.WallLanternTexturesRegistry;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.RedMerchantRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.SkullCandleOverlayModel;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.pickle.JarredModel;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.pickle.PickleModel;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BellowsBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BookPileBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.ClockBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.GlobeBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.SignPostBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BookPileBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.LabelEntity;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.common.util.NonNullLazy;
import org.apache.commons.lang3.Validate;

public class ClientRegistry {
    public static GlobeBlockTileRenderer GLOBE_RENDERER_INSTANCE = null;
    public static final Material BLACKBOARD_OUTLINE = new Material(TextureAtlas.f_118259_, Textures.BLACKBOARD_GRID);
    public static final Material BELLOWS_MATERIAL = new Material(TextureAtlas.f_118259_, Textures.BELLOWS_TEXTURE);
    public static final Material BUBBLE_BLOCK_MATERIAL = new Material(TextureAtlas.f_118259_, Textures.BUBBLE_BLOCK_TEXTURE);
    public static final Material BOOK_ENCHANTED_MATERIAL = new Material(Sheets.f_110735_, Textures.BOOK_ENCHANTED_TEXTURES);
    public static final Material BOOK_TOME_MATERIAL = new Material(Sheets.f_110735_, Textures.BOOK_TOME_TEXTURES);
    public static final Material BOOK_WRITTEN_MATERIAL = new Material(Sheets.f_110735_, Textures.BOOK_WRITTEN_TEXTURES);
    public static final Material BOOK_AND_QUILL_MATERIAL = new Material(Sheets.f_110735_, Textures.BOOK_AND_QUILL_TEXTURES);
    public static final Map<BookPileBlockTile.BookColor, Material> BOOK_MATERIALS = new HashMap<BookPileBlockTile.BookColor, Material>();
    public static final Map<WoodType, Material> SIGN_POSTS_MATERIALS = new HashMap<WoodType, Material>();
    public static final Supplier<Map<BannerPattern, Material>> FLAG_MATERIALS = Suppliers.memoize(() -> {
        HashMap<BannerPattern, Material> map = new HashMap<BannerPattern, Material>();
        for (BannerPattern pattern : BannerPattern.values()) {
            map.put(pattern, new Material(Sheets.f_110737_, Textures.FLAG_TEXTURES.get(pattern)));
        }
        return map;
    });
    public static final ResourceLocation QUIVER_3D_MODEL = Supplementaries.res("item/quiver_in_hand_dyed");
    public static final ResourceLocation QUIVER_2D_MODEL = Supplementaries.res("item/quiver_gui_dyed");
    public static final ResourceLocation FLUTE_3D_MODEL = Supplementaries.res("item/flute_in_hand");
    public static final ResourceLocation FLUTE_2D_MODEL = Supplementaries.res("item/flute_gui");
    public static final ResourceLocation BOAT_MODEL = Supplementaries.res("block/jar_boat_ship");
    public static final ResourceLocation WIND_VANE_BLOCK_MODEL = Supplementaries.res("block/wind_vane_up");
    public static final ResourceLocation HANGING_POT_BLOCK_MODEL = Supplementaries.res("block/hanging_flower_pot");
    public static final Map<WoodType, ResourceLocation> HANGING_SIGNS_BLOCK_MODELS = new HashMap<WoodType, ResourceLocation>();
    public static final Map<LabelEntity.AttachType, ResourceLocation> LABEL_MODELS = new HashMap<LabelEntity.AttachType, ResourceLocation>(){
        {
            this.put(LabelEntity.AttachType.BLOCK, Supplementaries.res("block/label"));
            this.put(LabelEntity.AttachType.CHEST, Supplementaries.res("block/label_chest"));
            this.put(LabelEntity.AttachType.JAR, Supplementaries.res("block/label_jar"));
        }
    };
    public static ModelLayerLocation BELLOWS_MODEL;
    public static ModelLayerLocation BOOK_MODEL;
    public static ModelLayerLocation CLOCK_HANDS_MODEL;
    public static ModelLayerLocation GLOBE_BASE_MODEL;
    public static ModelLayerLocation GLOBE_SPECIAL_MODEL;
    public static ModelLayerLocation SIGN_POST_MODEL;
    public static ModelLayerLocation RED_MERCHANT_MODEL;
    public static ModelLayerLocation SKULL_CANDLE_OVERLAY;
    public static ModelLayerLocation JARVIS_MODEL;
    public static ModelLayerLocation PICKLE_MODEL;

    private static ModelLayerLocation loc(String name) {
        return new ModelLayerLocation(Supplementaries.res(name), name);
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BELLOWS_MODEL, BellowsBlockTileRenderer::createMesh);
        event.registerLayerDefinition(BOOK_MODEL, BookPileBlockTileRenderer::createMesh);
        event.registerLayerDefinition(CLOCK_HANDS_MODEL, ClockBlockTileRenderer::createMesh);
        event.registerLayerDefinition(GLOBE_BASE_MODEL, GlobeBlockTileRenderer::createBaseMesh);
        event.registerLayerDefinition(GLOBE_SPECIAL_MODEL, GlobeBlockTileRenderer::createSpecialMesh);
        event.registerLayerDefinition(SIGN_POST_MODEL, SignPostBlockTileRenderer::createMesh);
        event.registerLayerDefinition(RED_MERCHANT_MODEL, RedMerchantRenderer::createMesh);
        event.registerLayerDefinition(SKULL_CANDLE_OVERLAY, SkullCandleOverlayModel::createMesh);
        event.registerLayerDefinition(JARVIS_MODEL, JarredModel::createMesh);
        event.registerLayerDefinition(PICKLE_MODEL, PickleModel::createMesh);
    }

    public static void registerSpecialModels() {
        FlowerPotHandler.CUSTOM_MODELS.forEach(ForgeModelBakery::addSpecialModel);
        WallLanternTexturesRegistry.SPECIAL_TEXTURES.values().forEach(ForgeModelBakery::addSpecialModel);
        HANGING_SIGNS_BLOCK_MODELS.values().forEach(ForgeModelBakery::addSpecialModel);
        LABEL_MODELS.values().forEach(ForgeModelBakery::addSpecialModel);
        ForgeModelBakery.addSpecialModel((ResourceLocation)HANGING_POT_BLOCK_MODEL);
        ForgeModelBakery.addSpecialModel((ResourceLocation)WIND_VANE_BLOCK_MODEL);
        ForgeModelBakery.addSpecialModel((ResourceLocation)FLUTE_3D_MODEL);
        ForgeModelBakery.addSpecialModel((ResourceLocation)FLUTE_2D_MODEL);
        ForgeModelBakery.addSpecialModel((ResourceLocation)BOAT_MODEL);
    }

    public static void registerISTER(Consumer<IItemRenderProperties> consumer, final BiFunction<BlockEntityRenderDispatcher, EntityModelSet, BlockEntityWithoutLevelRenderer> factory) {
        consumer.accept(new IItemRenderProperties(){
            final NonNullLazy<BlockEntityWithoutLevelRenderer> renderer = NonNullLazy.of(() -> (BlockEntityWithoutLevelRenderer)factory.apply(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.renderer.get();
            }
        });
    }

    static {
        Validate.isTrue((!WoodTypeRegistry.WOOD_TYPES.values().isEmpty() ? 1 : 0) != 0);
        ModRegistry.HANGING_SIGNS.forEach((wood, block2) -> HANGING_SIGNS_BLOCK_MODELS.put((WoodType)wood, Supplementaries.res("block/hanging_signs/" + block2.getRegistryName().m_135815_())));
        ModRegistry.SIGN_POST_ITEMS.forEach((wood, item2) -> SIGN_POSTS_MATERIALS.put((WoodType)wood, new Material(TextureAtlas.f_118259_, Supplementaries.res("entity/sign_posts/" + item2.getRegistryName().m_135815_()))));
        for (BookPileBlockTile.BookColor color : BookPileBlockTile.BookColor.values()) {
            BOOK_MATERIALS.put(color, new Material(Sheets.f_110735_, Textures.BOOK_TEXTURES.get((Object)color)));
        }
        BELLOWS_MODEL = ClientRegistry.loc("bellows");
        BOOK_MODEL = ClientRegistry.loc("book");
        CLOCK_HANDS_MODEL = ClientRegistry.loc("clock_hands");
        GLOBE_BASE_MODEL = ClientRegistry.loc("globe");
        GLOBE_SPECIAL_MODEL = ClientRegistry.loc("globe_special");
        SIGN_POST_MODEL = ClientRegistry.loc("sign_post");
        RED_MERCHANT_MODEL = ClientRegistry.loc("red_merchant");
        SKULL_CANDLE_OVERLAY = ClientRegistry.loc("skull_candle");
        JARVIS_MODEL = ClientRegistry.loc("jarvis");
        PICKLE_MODEL = ClientRegistry.loc("pickle");
    }

    public static class RR
    extends RenderType {
        public static final Function<ResourceLocation, RenderType> TRANSPARENT_TEXTURE = Util.m_143827_(texture -> RR.createGenericRenderType("test_texture", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, RenderStateShard.f_173103_, RenderStateShard.f_110139_, (RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)));

        public RR(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }

        public static RenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, RenderStateShard.EmptyTextureStateShard texture) {
            return RenderType.m_173215_((String)name, (VertexFormat)format, (VertexFormat.Mode)mode, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(shader).m_110687_(new RenderStateShard.WriteMaskStateShard(true, true)).m_110671_(new RenderStateShard.LightmapStateShard(false)).m_110685_(transparency).m_173290_(texture).m_110661_(new RenderStateShard.CullStateShard(true)).m_110691_(true));
        }
    }
}

